#include "dots.h" 
#include "TDotsWindow.h"

#pragma mark --Variables--
//
// All this stuff is only touched by functions in this file
//

#define COS_TABLE_SIZE	2880
#define MAXGROUPS		40
#define MAXDOTS			1000

static float	 gCosTable[COS_TABLE_SIZE];		// Table of Cos(x/4)

//Individual Dot Parameters
static char gDotColor[MAXDOTS];
static long gDotSize[MAXDOTS];
static long gX[2][MAXDOTS];
static long gY[2][MAXDOTS];
static long gXOld[2][MAXDOTS];
static long gYOld[2][MAXDOTS];
static long gDotInUse[MAXDOTS];
static long gDotDrawn[MAXDOTS];
static long gDotLong1[MAXDOTS];
static long gDotLong2[MAXDOTS];

static long gLastDot;

//Group Parameters
static long gGroupsActive;
static float gWidthFactor;
static float gHeightFactor;
static long gGroupActive[MAXGROUPS];
static long gGroupType[MAXGROUPS];
static long gGroupStart[MAXGROUPS];
static long gGroupEnd[MAXGROUPS];
static long gGroupDots[MAXGROUPS];
static long gNextDot[MAXGROUPS];

static float 	gDegree1[MAXGROUPS];
static float 	gDegree2[MAXGROUPS];
static long	gWidth[MAXGROUPS];
static long	gHeight[MAXGROUPS];
static long	gGroupX[MAXGROUPS];
static long	gGroupY[MAXGROUPS];
static long	gGroupCount[MAXGROUPS];
static long	gGroupLong1[MAXGROUPS];
static long	gGroupLong2[MAXGROUPS];
static long gGroupColor[MAXGROUPS];

float	gFrameSpeed;

// Setting Parameters
long	gFrameTime = 100;

long	gMaxGroups= MAXGROUPS;
long	gMaxDots = MAXDOTS;
long	gErase = 1;

// Clover Parameters
//
// gCloverSpacing * gCloverSpeed * 20 < 2880
//
long	gCloverRotation = 3; // Clover Rotation per Cycle
long	gCloverSpacing = 12; // Cycles between new dots
long	gCloverSpeed = 3; // Speed of clover dots

long	gVariableSpacing = 6;
long	gVariableSpeed = 12;
long	gVariableMaxRotation = 30;
long	gVariableChance = 400;

long	gSphereDelay = 15;
long	gSphereSpeed = 9;

long	gCircleSpacing = 12;
long	gCircleSpeed = 12;
long	gCircleRotation = 8;	

long 	gGroupChance = 20;

uint32	gScreenSpace = B_8_BIT_640x480;

#pragma mark --Functions--
// Functions

// Main thread of the domino player.

long Play(void *param)
{
	gFrameSpeed = 1000000.0 / gFrameTime;
	double		totalTime=0,drawTime=0,switchTime=0,updateTime=0,theLoopTime,thePause;
	long		theCount=0;
// Get a copy of the window object.
	window = (TDotsWindow*)param;

	FillCosTable();
// Wait for the first ScreenConnected(TRUE). Sorry, it's a pooler (add a semaphore
// if you want...)
	while (!drawing_enabled) {
	// Kill the domino player when ask.	
		if (kill_play) goto end;
		snooze(2e5);
	}
	snooze(3e5);
	
	totalTime = system_time();
	
	InitializeGroups();
	NewGroup();
	
	while (TRUE) {
		theLoopTime = system_time();

		if (kill_play) goto end;
		

		acquire_sem(lock);
		if (drawing_enabled) {
			
			UpdateGroups();						
			DrawGroups();
			SwitchBuffer();
		}
		else
			snooze(2e4);
			
		release_sem(lock);
		
		
		int theRand = rand()% gGroupChance;
		if (theRand == 0)
			NewGroup();
		
		if ( (thePause = gFrameSpeed - (system_time() - theLoopTime) ) > 0)
		{
			snooze(thePause);
		}
	
	}
done:
	totalTime = system_time() - totalTime;
	printf("Total: %f\nDraw: %f\nSwitch: %f\nUpdate: %f\n",totalTime,drawTime,switchTime,updateTime);
 end:

// do some clean-up...
// release the semaphore blocking the window thread
	release_sem(ender);
	return 0;
}




#pragma mark --Group Control Functions--

void		 InitializeGroups()
{
	for(long i=0;i<MAXGROUPS;i++)
	{
		gGroupActive[i]=0;
		gGroupType[i]=-1;
		gGroupStart[i]=-1;
		gGroupEnd[i]=-1;
		gGroupDots[i]=0;
		gNextDot[i]=0;

		gDegree1[i]=0;
		gDegree2[i]=0;
		gWidth[i]=0;
		gHeight[i]=0;
		gGroupX[i]=0;
		gGroupY[i]=0;
		gGroupCount[i]=0;
	}
	
	gWidthFactor = 1;
	gHeightFactor = 1;
	gGroupsActive=0;

	for (long j=0;j<gMaxDots;j++)
	{
		gDotColor[j]=0;
		gDotSize[j]=1;
		gX[0][j]=0;
		gY[0][j]=0;
		gX[1][j]=0;
		gY[1][j]=0;
		gXOld[0][j]=0;
		gYOld[0][j]=0;
		gXOld[1][j]=0;
		gYOld[1][j]=0;
		gDotInUse[j]=0;
		gDotDrawn[j]=0;
	}
	
	gLastDot = 0;
}



void	NewGroup()
{
	if (gGroupsActive == MAXGROUPS )
		return;
	
	long theGroup = FindFreeGroup();
		
	// Generate Random number for group type
	long theType;
	
	if ( gGroupsActive == MAXGROUPS -1 || DotsUsed() > gMaxDots-50)
	{
		theType = 0;
		NewEnd(theGroup,theType);
	}
	else
	{
		long theRand =  rand() % 100;
		if ( theRand < 30)
			theType=1;
		else if (theRand < 60)
			theType=2;
		else if (theRand < 90)
			theType=3;
		else
			theType=4;
	}

	switch(theType)
	{
	case 2:
	case 3:
		NewCircle(theGroup,theType);
		break;
	case 1:
		NewClover(theGroup,theType);
		break;
	case 4:
		NewSphere(theGroup,theType);
		break;
	case 5:
		NewSpiral(theGroup,theType);
		break;
	case 0:
		NewEnd(theGroup,theType);
		break;
	}

}

long		FindFreeGroup()
{
	for (long i=0;i<MAXGROUPS;i++)
	{
		if ( gGroupActive[i] == 0)
			return i;
	}
	return 0;
}

long 	 GrabDots(long inRequested,long*outStart,long*outEnd)
{
	long theMaxCount = 0;
	long theMaxStart  = 0, theMaxEnd = 0;
	long theCount=0,theStart=0,theEnd=0;
	long theLastDot;
	
	for ( long j = 0; j<gMaxDots; j++)
	{
		if ( gDotInUse[j] == 1 )
		{
			theLastDot = j;
		}
	}
	
	gLastDot = theLastDot + inRequested + 1 > gMaxDots ? gMaxDots : theLastDot + inRequested + 1;
	


	for ( long i = 0; i<gMaxDots; i++)
	{
		if ( gDotInUse[i] == 0 )
		{
			theCount ++;
			theEnd = i+1;
			
			if ( theCount == inRequested )
			{
				*outStart=theStart;
				*outEnd = theEnd;
				return theCount;
			}
		}
		else
		{
			if ( theCount > theMaxCount )
			{
				theMaxCount = theCount;
				theMaxStart = theStart;
				theMaxEnd = theEnd;
			}
			theStart = i+1;
			theEnd = i+1;
			theCount = 0;
		}
	}
	
	*outStart = theMaxStart;
	*outEnd = theMaxEnd;
	
	return theMaxCount;	
}

long DotsLeft()
{
	long count=0, i;
	for (i=0;i<gMaxDots;i++)
	{
		if ( gDotInUse[i] == 0 )
			count++;
	}
	return count;
}

long DotsUsed()
{
	long count=0, i;
	for (i=0;i<gMaxDots;i++)
	{
		if ( gDotInUse[i] != 0 )
			count++;
	}
	return count;
}

void ResetGroups(long inGroup)
{
	printf("Resetting groups.\n");
	
	for(long i=0;i<MAXGROUPS;i++)
	{
		if (i != inGroup)
		{
			gGroupActive[i] = 0;
		}
	}
	

}



void		 UpdateGroups()
{

	for (long i=0;i<MAXGROUPS;i++)
	{
		if (gGroupActive[i] == 1)
		{
			switch(gGroupType[i])
			{
				case 1:
					UpdateClover(i);
					break;
				case 2:
					UpdateCircle(i);
					break;
				case 3:
					UpdateVariableCircle(i);
					break;
				case 4:
					UpdateSphere(i);
					break;
				case 5:
					UpdateSpiral(i);
					break;
				case 0:
					UpdateEnd(i);
					break;
			}
		}
	}
}

// These Don't Really Belong here, but they have to be cause they are inline

void DrawGroups()
{
	// Erase Loop
	long i;
	
	if ( gErase )
	{
		for (i = 0; i<gLastDot; i++)
		{
			if (gDotDrawn[i] != 0)
			{
					if (gDotDrawn[i] < 0)
						gDotDrawn[i]++;
				
				// Erase the Dot
				if ( gDotSize[i] == 1)
					plot_point ( gXOld[page_num][i],gYOld[page_num][i],1);
				else
					plot_dot ( gXOld[page_num][i],gYOld[page_num][i],1);
			}
		}
	}

	for (i = 0; i<gLastDot; i++)
	{
		if (gDotDrawn[i] > 0)
		{			
			// Draw the Dot
			if ( gDotSize[i] == 1)
				plot_point ( gX[page_num][i],gY[page_num][i],gDotColor[i]);
			else
				plot_dot ( gX[page_num][i],gY[page_num][i],gDotColor[i]);
		}
	}
}

#pragma mark --Utilities--
void FillCosTable()
{
	for ( long x = 0; x < COS_TABLE_SIZE; x ++)
	{
		gCosTable[x] = cos( PI*(double)x*2/COS_TABLE_SIZE);
	}
}

inline float TableCos(float x)
{
	long index = ((long)x) % COS_TABLE_SIZE;
	return gCosTable[index];
}

inline float TableSin(float x)
{
	long index = (((long)x) + 720) % COS_TABLE_SIZE;
	return gCosTable[index];
}

void
CopySettingsOut(dots_param* outParam)
{
	outParam->CloverRotation=gCloverRotation; // Clover Rotation per Cycle
	outParam->CloverSpacing=gCloverSpacing; // Cycles between new dots
	outParam->CloverSpeed=gCloverSpeed; // Speed of clover dots
	
	outParam->VariableSpacing=gVariableSpacing ;
	outParam->VariableSpeed=gVariableSpeed;
	outParam->VariableMaxRotation=gVariableMaxRotation;
	outParam->VariableChance=gVariableChance;
	
	outParam->SphereDelay=gSphereDelay;
	outParam->SphereSpeed=gSphereSpeed;
	
	outParam->CircleSpacing=gCircleSpacing;
	outParam->CircleSpeed=gCircleSpeed;
	outParam->CircleRotation=gCircleRotation;	
	
	outParam->GroupChance=gGroupChance;
	outParam->Erase=gErase;
	outParam->FrameTime= gFrameTime;
	outParam->MaxGroups= gMaxGroups;
	outParam->MaxDots = gMaxDots;
	
	outParam->screen = gScreenSpace;

}

void
CopySettingsIn(dots_param* outParam)
{
	gCloverRotation=outParam->CloverRotation; // Clover Rotation per Cycle
	gCloverSpacing=outParam->CloverSpacing; // Cycles between new dots
	gCloverSpeed=outParam->CloverSpeed; // Speed of clover dots
	
	gVariableSpacing=outParam->VariableSpacing ;
	gVariableSpeed=outParam->VariableSpeed;
	gVariableMaxRotation=outParam->VariableMaxRotation;
	gVariableChance=outParam->VariableChance;
	
	gSphereDelay=outParam->SphereDelay;
	gSphereSpeed=outParam->SphereSpeed;
	
	gCircleSpacing=outParam->CircleSpacing;
	gCircleSpeed=outParam->CircleSpeed;
	gCircleRotation=outParam->CircleRotation;	
	
	gGroupChance=outParam->GroupChance;
	gErase=outParam->Erase;
	gFrameTime=outParam->FrameTime;
	gMaxGroups=outParam->MaxGroups;
	gMaxDots=outParam->MaxDots;
	
	gScreenSpace = outParam->screen;
}

#pragma mark --New Group Functions--

void		NewClover(long theGroup,long theType)
{
	// Grab a numer of dots
	long theRequestedDots = 20;
	long i;
	if ( gGroupDots[theGroup] == GrabDots(theRequestedDots, &gGroupStart[theGroup],&gGroupEnd[theGroup]))
	{
		printf("Group %d: Grabbed %d dots, indexes %d-%d.\n",theGroup,theRequestedDots,
							gGroupStart[theGroup],gGroupEnd[theGroup]);
		gGroupType[theGroup]=theType;
		gGroupActive[theGroup]=1;
		gGroupsActive++;
		gNextDot[theGroup] = gGroupStart[theGroup];
		
		// Generate some random location and size
		int theRand = rand() % 100; // 50;
		gWidth[theGroup]=180 + theRand;
		gHeight[theGroup]=180 + theRand;
		gGroupX[theGroup]=(gBounds.IntegerWidth() / 2);
		gGroupY[theGroup]=(gBounds.IntegerHeight() / 2);
		gGroupCount[theGroup]=0;
		gDegree1[theGroup]=0;
		gGroupColor[theGroup] = 90 + (rand() % 150);
		
		for (i=gGroupStart[theGroup];i<gGroupEnd[theGroup];i++)
		{
			gDotInUse[i] = 1;
		}
	}
}

void		NewCircle(long theGroup,long theType)
{
	// Grab a numer of dots
	long theRequestedDots = 20;
	long i;
	if ( gGroupDots[theGroup] == GrabDots(theRequestedDots, &gGroupStart[theGroup],&gGroupEnd[theGroup]) )
	{
		printf("Group %d: Grabbed %d dots, indexes %d-%d.\n",theGroup,theRequestedDots,
							gGroupStart[theGroup],gGroupEnd[theGroup]);
		gGroupType[theGroup]=theType;
		gGroupActive[theGroup]=1;
		gGroupsActive++;
		gNextDot[theGroup] = gGroupStart[theGroup];
		
		// Generate some random location and size
		int theRand = rand() % 300; //220;
		gWidth[theGroup]=20 + theRand;
		gHeight[theGroup]=20 + theRand;
		gGroupX[theGroup]=(gBounds.IntegerWidth() / 2);
		gGroupY[theGroup]=(gBounds.IntegerHeight() / 2);
		gGroupCount[theGroup]=0;
		
		gGroupLong1[theGroup]=2;
		gGroupLong2[theGroup]=gWidth[theGroup];
		
		gGroupColor[theGroup] = 90 + (rand() % 150);

		for (i=gGroupStart[theGroup];i<gGroupEnd[theGroup];i++)
		{
			gDotInUse[i] = 1;
		}
	}
}

void NewSpiral(long theGroup,long theType)
{
	// Grab a numer of dots
	long theRequestedDots = 20;
	long i;
	if ( gGroupDots[theGroup] == GrabDots(theRequestedDots, &gGroupStart[theGroup],&gGroupEnd[theGroup]) )
	{
		printf("Group %d: Grabbed %d dots, indexes %d-%d.\n",theGroup,theRequestedDots,
							gGroupStart[theGroup],gGroupEnd[theGroup]);
		gGroupType[theGroup]=theType;
		gGroupActive[theGroup]=1;
		gGroupsActive++;
		gNextDot[theGroup] = gGroupStart[theGroup];
		
		// Generate some random location and size
		int theRand = rand() % 300; //220;
		gWidth[theGroup]=20 + theRand;
		gHeight[theGroup]=20 + theRand;
		gGroupX[theGroup]=(gBounds.IntegerWidth() / 2);
		gGroupY[theGroup]=(gBounds.IntegerHeight() / 2);
		gGroupCount[theGroup]=0;
		
		gGroupLong1[theGroup]=1;
		gGroupLong2[theGroup]=gWidth[theGroup];
		
		gGroupColor[theGroup] = 90 + (rand() % 150);

		for (i=gGroupStart[theGroup];i<gGroupEnd[theGroup];i++)
		{
			gDotInUse[i] = 1;
		}
	}
}
#define	SPHERE_DENSITY	12
#define SPHERE_SPACE	(gBounds.IntegerHeight() / 2)

void		NewSphere(long theGroup, long theType)
{
	long	theRings = (rand() % 4) * 2 + 5;
	
	long 	theRequest = theRings * SPHERE_DENSITY;
	
	if ( (gGroupDots[theGroup] = GrabDots(theRequest, 
											&gGroupStart[theGroup],
											&gGroupEnd[theGroup])) == theRequest)
	{
		printf("Group %d: New Sphere, grabbed %d, index %d-%d.\n",theGroup,theRequest,
						gGroupStart[theGroup],gGroupEnd[theGroup]);
	
		gGroupType[theGroup]=theType;
		gGroupActive[theGroup]=1;
		gGroupsActive++;
		
		// Generate some randome size and figure some stuff out
		int theRand = rand() % (gBounds.IntegerHeight() / 2 - 20);
		gWidth[theGroup] = 20+ theRand;
		gHeight[theGroup] = 20 + theRand;
		gGroupX[theGroup]=(gBounds.IntegerWidth() / 2); 
		gGroupY[theGroup]=(gBounds.IntegerHeight() / 2)- ( 20 + theRand)/2; // Top of circle, not center
		gGroupCount[theGroup]=0;
		gGroupColor[theGroup] = 90 + (rand() % 150);

		gNextDot[theGroup]=0;
		
		gGroupLong1[theGroup]=theRings;
		gGroupLong2[theGroup]=gHeight[theGroup]/(theRings+1);

		long j=gGroupStart[theGroup];
		for(long i=1;i<=theRings;i++)
		{
			long theY = gGroupY[theGroup] + gGroupLong2[theGroup]*i;
			long theRingWidth = gHeight[theGroup] * gHeight[theGroup] / 4 - ( (gBounds.IntegerHeight() / 2) - theY ) * ( (gBounds.IntegerHeight() / 2) - theY);
			theRingWidth = sqrt(theRingWidth);
			
			for(long k=0;k< SPHERE_DENSITY ;k++,j++)
			{
				gDotInUse[j]=1;
				gDotLong1[j]=theRingWidth;
			}
		}

	}
	
}

void		NewEnd(long theGroup,long theType)
{
	// Grab a numer of dots
	gGroupType[theGroup]=theType;
	gGroupActive[theGroup]=1;
	gGroupsActive++;

	// gGroupLong specifies type of closing
	// 1 = width
	// 2 = height
	// 3 = both
	
	gGroupLong1[theGroup]= rand() % 3 +1;
}

#pragma mark --Update Group Functions--

void UpdateClover(long inGroup)
{
	if ( gNextDot[inGroup] < gGroupEnd[inGroup] && gGroupCount[inGroup] == 0)
	{
		long theNextDot = gNextDot[inGroup];
		gDotColor[theNextDot] = gGroupColor[inGroup];
		
		gDotLong1[theNextDot]=0;
		gDotDrawn[theNextDot]=1;
		gDotSize[theNextDot] = theNextDot % 2 + 1;
		
		gNextDot[inGroup]++;
		gGroupCount[inGroup]++;
	}
	else
	{
		gGroupCount[inGroup] = ++gGroupCount[inGroup] % gCloverSpacing;
	}

	float t;
	float rot;
	
	gDegree1[inGroup] += gCloverRotation;
	if ( gDegree1[inGroup] > COS_TABLE_SIZE)
		gDegree1[inGroup] = 0;
	
	float theWidth, theHeight;
	
	theWidth = gWidth[inGroup] * gWidthFactor;
	theHeight = gHeight[inGroup] * gHeightFactor;
	
	rot = gDegree1[inGroup];

	for (long i=gGroupStart[inGroup];i<gNextDot[inGroup];i++)
	{		
		gXOld[page_num][i] = gX[page_num][i];
		gYOld[page_num][i] = gY[page_num][i];
		

		t = gDotLong1[i];
		
		gDotLong1[i] +=gCloverSpeed;
		if ( gDotLong1[i] > COS_TABLE_SIZE)
			gDotLong1[i] = 0;
		
		gX[page_num][i] = TableCos( t ) * TableCos ( 2*(t+rot)) 
							* theWidth + gGroupX[inGroup];
		gY[page_num][i] = TableSin( t ) * TableCos ( 2*(t+rot)) 
							* theHeight + gGroupY[inGroup];
				
	}
}

void UpdateCircle(long inGroup)
{
	if ( gNextDot[inGroup] < gGroupEnd[inGroup] && gGroupCount[inGroup] == 0)
	{
		long theNextDot = gNextDot[inGroup];
		gDotColor[theNextDot] = gGroupColor[inGroup];
		
		gDotLong1[theNextDot]=0;
		gDotDrawn[theNextDot]=1;
		gDotSize[theNextDot] = theNextDot % 2 + 1;
		
		gNextDot[inGroup]++;
		gGroupCount[inGroup]++;
	}
	else
	{
		gGroupCount[inGroup] = ++gGroupCount[inGroup] % gCircleSpacing;
	}

	float t;
	
	gGroupLong1[inGroup] += gCircleRotation;
	if ( gGroupLong1[inGroup] > COS_TABLE_SIZE )
		gGroupLong1[inGroup]=0;
	
	gWidth[inGroup] = TableCos( gGroupLong1[inGroup]) * gGroupLong2[inGroup];
		
	float theWidth, theHeight;
	
	theWidth = gWidth[inGroup] * gWidthFactor;
	theHeight = gHeight[inGroup] * gHeightFactor;

	for (long i=gGroupStart[inGroup];i<gNextDot[inGroup];i++)
	{		
		gXOld[page_num][i] = gX[page_num][i];
		gYOld[page_num][i] = gY[page_num][i];

		t = gDotLong1[i];
		
		gDotLong1[i] +=gCircleSpeed;
		if ( gDotLong1[i] > COS_TABLE_SIZE)
			gDotLong1[i] = 0;
		
		gX[page_num][i] = TableCos( t ) * theWidth + gGroupX[inGroup];
		gY[page_num][i] = TableSin( t ) * theHeight + gGroupY[inGroup];
				
	}
}

void UpdateSpiral(long inGroup)
{
	if ( gNextDot[inGroup] < gGroupEnd[inGroup] && gGroupCount[inGroup] == 0)
	{
		long theNextDot = gNextDot[inGroup];
		gDotColor[theNextDot] = gGroupColor[inGroup];
		
		gDotLong1[theNextDot]=0;
		gDotDrawn[theNextDot]=1;
		gDotSize[theNextDot] = theNextDot % 2 + 1;
		
		gNextDot[inGroup]++;
		gGroupCount[inGroup]++;
	}
	else
	{
		gGroupCount[inGroup] = ++gGroupCount[inGroup] % 12;
	}

	float t;
	
	gGroupLong1[inGroup] += 8;
	if ( gGroupLong1[inGroup] > COS_TABLE_SIZE )
		gGroupLong1[inGroup]=0;
		
	float rot = gGroupLong1[inGroup];
	
	//gWidth[inGroup] = TableCos( gGroupLong1[inGroup]) * gGroupLong2[inGroup];
		
	float theWidth, theHeight;
	
	theWidth = gWidth[inGroup] * gWidthFactor;
	theHeight = gHeight[inGroup] * gHeightFactor;

	for (long i=gGroupStart[inGroup];i<gNextDot[inGroup];i++)
	{		
		gXOld[page_num][i] = gX[page_num][i];
		gYOld[page_num][i] = gY[page_num][i];

		
		//gDotLong1[i] -=12;
		if ( gDotLong1[i] < 0)
			gDotLong1[i] = COS_TABLE_SIZE;
		
		t = gDotLong1[i] + rot;
		
		gX[page_num][i] = TableCos( t ) * t/COS_TABLE_SIZE * theWidth + gGroupX[inGroup];
		gY[page_num][i] = TableSin( t ) * t/COS_TABLE_SIZE * theHeight + gGroupY[inGroup];
				
	}
}

void UpdateVariableCircle(long inGroup)
{
	if ( gNextDot[inGroup] < gGroupEnd[inGroup] && gGroupCount[inGroup] == 0)
	{
		long theNextDot = gNextDot[inGroup];
		gDotColor[theNextDot] = gGroupColor[inGroup];
		
		gDotLong1[theNextDot]=0;
		gDotDrawn[theNextDot]=1;
		gDotSize[theNextDot] = theNextDot % 2 + 1;
		
		gNextDot[inGroup]++;
		gGroupCount[inGroup]++;
	}
	else
	{
		gGroupCount[inGroup] = ++gGroupCount[inGroup] % gVariableSpacing;
	}

	float t;
	float rot;
	
	if (rand() % gVariableChance == 0)
		 gGroupLong1[inGroup] *=-1;
		
	gGroupLong2[inGroup] += gGroupLong1[inGroup];
	if ( gGroupLong2[inGroup] > gVariableMaxRotation )
		gGroupLong2[inGroup] = gVariableMaxRotation;
	if ( gGroupLong2[inGroup] <  - (gVariableMaxRotation + gVariableSpeed) )
		gGroupLong2[inGroup] = - (gVariableMaxRotation + gVariableSpeed);
	
	gDegree1[inGroup] += gGroupLong2[inGroup];
	if ( gDegree1[inGroup] > COS_TABLE_SIZE )
		gDegree1[inGroup] = 0;
	else if (gDegree1[inGroup] < 0)
		gDegree1[inGroup] = COS_TABLE_SIZE-1;
	
	float theWidth, theHeight;
	
	theWidth = gWidth[inGroup] * gWidthFactor;
	theHeight = gHeight[inGroup] * gHeightFactor;
		
	for (long i=gGroupStart[inGroup];i<gNextDot[inGroup];i++)
	{		
		gXOld[page_num][i] = gX[page_num][i];
		gYOld[page_num][i] = gY[page_num][i];
		
		rot = gDegree1[inGroup];

		t = gDotLong1[i] - rot;
		
		while ( t < 0 )
			t += COS_TABLE_SIZE;
		
		gDotLong1[i] +=gVariableSpeed;
		if ( gDotLong1[i] > COS_TABLE_SIZE)
			gDotLong1[i] = 0;
		
		gX[page_num][i] = TableCos( t ) * theWidth + gGroupX[inGroup];
		gY[page_num][i] = TableSin( t ) * theHeight + gGroupY[inGroup];
				
	}
}

void UpdateSphere(long inGroup)
{
	if ( gNextDot[inGroup] < gGroupLong1[inGroup] && gGroupCount[inGroup] == 0)
	{
		// Create new ring
		long theStart = gGroupStart[inGroup] + gNextDot[inGroup] * SPHERE_DENSITY;
		long theEnd = theStart + SPHERE_DENSITY;
		//printf("Created new ring: Group %d, ring %d, start %d, end %d.\n",inGroup,gNextDot[inGroup],theStart,theEnd);
		long theAngle = 0;
		for (;theStart < theEnd;theStart++,theAngle+=SPHERE_SPACE)
		{
			gDotDrawn[theStart] = 1;
			gDotLong2[theStart] = theAngle;
			gDotColor[theStart] = gGroupColor[inGroup];
			gDotSize[theStart] = theStart % 2 +1;
		}
		
		gGroupCount[inGroup]++;
		gNextDot[inGroup]++;
	}
	else
	{
		// Increase Group Count
		gGroupCount[inGroup] = ++gGroupCount[inGroup] % gSphereDelay;
	}

	
	// Draw the Rings
	long theCurrentDot = gGroupStart[inGroup];
	gDegree1[inGroup] += gSphereSpeed;
	if ( gDegree1[inGroup] > COS_TABLE_SIZE)
		gDegree1[inGroup] -= COS_TABLE_SIZE;
	
	for ( long i=1; i<= gNextDot[inGroup]; i++)
	{
		// Each ring is here
		long theWidth = gDotLong1[theCurrentDot] * gWidthFactor;
		long theHeight = theWidth / 3 * gHeightFactor;
		long theY = gGroupY[inGroup] + gGroupLong2[inGroup] * i;
		long theX = gGroupX[inGroup];
		long t;
		long rot = gDegree1[inGroup];

		for (long j=0;j<SPHERE_DENSITY;j++,theCurrentDot++)
		{
			gXOld[page_num][theCurrentDot] = gX[page_num][theCurrentDot];
			gYOld[page_num][theCurrentDot] = gY[page_num][theCurrentDot];

			t = gDotLong2[theCurrentDot] + rot;
									
			gX[page_num][theCurrentDot] = TableCos( t ) * theWidth + theX;
			gY[page_num][theCurrentDot] = TableSin( t ) * theHeight + theY;
		}

		
	}



}

void UpdateEnd(long inGroup)
{
	if ( gGroupLong1[inGroup] == 1 )
	{
		gWidthFactor -= 0.005;
		
		if ( gWidthFactor < 0)
		{
			gWidthFactor = 0;
			ResetGroups(inGroup);
			gGroupLong1[inGroup] = 0;
		}
	}
	else if ( gGroupLong1[inGroup] == 2 )
	{
		gHeightFactor -= 0.005;
		
		if ( gHeightFactor < 0)
		{
			gHeightFactor = 0;
			ResetGroups(inGroup);
			gGroupLong1[inGroup] = 0;
		}
	}	
	else if ( gGroupLong1[inGroup] == 3 )
	{
		gHeightFactor -= 0.005;
		gWidthFactor -= 0.005;
		
		if ( gHeightFactor < 0)
		{
			gHeightFactor = 0;
		}
		
				if ( gWidthFactor < 0)
		{
			gWidthFactor = 0;
			ResetGroups(inGroup);
			gGroupLong1[inGroup] = 0;
		}

	}		
	else
	if ( gGroupLong1[inGroup] == 0 )
	{
		InitializeGroups();
		clear_buffer(1);
		SwitchBuffer();
		clear_buffer(1);
	}
}

